unit fUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ImageHlp;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    OpenDialog1: TOpenDialog;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure ListDLLExports(const FileName: string; List, ListI: TStrings);
 type
   TDWordArray = array [0..$FFFFF] of DWORD;
 var
   imageinfo: LoadedImage;
   pExportDirectory: PImageExportDirectory;
   dirsize: Cardinal;
   pDummy: PImageSectionHeader;
   i, Base: Cardinal;
   pNameRVAs: ^TDWordArray;
   pIndexRVAs: ^TWordArray;
   Name: string;
 begin
   List.Clear;
   if MapAndLoad(PChar(FileName), nil, @imageinfo, True, True) then
   begin
     try
       pExportDirectory := ImageDirectoryEntryToData(imageinfo.MappedAddress,
         False, IMAGE_DIRECTORY_ENTRY_EXPORT, dirsize);
       if (pExportDirectory <> nil) then
       begin
         pNameRVAs := ImageRvaToVa(imageinfo.FileHeader, imageinfo.MappedAddress, DWORD(pExportDirectory^.AddressOfNames), pDummy);
         pIndexRVAs:= ImageRvaToVa(imageinfo.FileHeader, imageinfo.MappedAddress, DWORD(pExportDirectory^.AddressOfNameOrdinals), pDummy);
         Base:=pExportDirectory^.Base;
         for i := 0 to pExportDirectory^.NumberOfNames - 1 do
         begin
           Name := PChar(ImageRvaToVa(imageinfo.FileHeader, imageinfo.MappedAddress, pNameRVAs^[i], pDummy));
           List.Add(Name);
           ListI.Add(IntToStr(pIndexRVAs^[i]+Base));
         end;
       end;
     finally
       UnMapAndLoad(@imageinfo);
     end;
   end;
 end;

procedure TForm1.FormCreate(Sender: TObject);
var fList, fListI: TStrings;
    i: cardinal;
    eStr: String;

    function dcomp (fname: string): string;
    begin
       Result:=StringReplace (fName, '@', '', []);
    end;

begin
   OpenDialog1.InitialDir:=ExtractFilePath(ParamStr(0));
   if OpenDialog1.Execute then begin
      fList := TStringList.Create;
      fListI:= TStringList.Create;
      ListDLLExports (OpenDialog1.FileName, fList, fListI);
      Memo1.Lines[6]:='var aDWORD: array [0..'+ IntToStr(fList.Count-1) +'] of DWORD;';

      for i:=0 to fList.Count-1 do begin
         Memo1.Lines.Add('');
         Memo1.Lines.Add('procedure ' + dcomp(fList[i]) + ';');
         Memo1.Lines.Add('asm');
         Memo1.Lines.Add('   jmp dword [aDWORD+' + IntToStr(i*4) + '];');
         Memo1.Lines.Add('end;');
      end;
      Memo1.Lines.Add('(* ------------ *)');
      Memo1.Lines.Add('');

      Memo1.Lines.Add('exports');
      for i:=0 to fList.Count-1 do begin
         eStr:='   ' + dcomp(fList[i]) + ' index ' + fListI[i] + ' name ''' + fList[i] + '''';
         if i<>fList.Count-1 then eStr:=eStr+',' else eStr:=eStr + ';';
         Memo1.Lines.Add(eStr);
      end;
      Memo1.Lines.Add('');
      Memo1.Lines.Add('initialization SetProcedure;');
      Memo1.Lines.Add('');
      Memo1.Lines.Add('end.');
      Memo1.Lines.SaveToFile(OpenDialog1.InitialDir + '\fake.pas');
   end;
end;

end.
