unit fake;

interface

uses Windows, SysUtils;

var aDWORD: array [0..4] of DWORD;

implementation

procedure SetProcedure;
type
    TDWordArray = array [0..$FFFFF] of DWORD;
var lib: THandle;
    NameRealDll, NameDll, Name: String;
    i, mylib: DWORD;
    pExportDirectory: PImageExportDirectory;
    pNameRVAs: ^TDWordArray;

   function GetModuleName: string;
   var S: array[0..MAX_PATH] of Char;
   begin
     GetModuleFileName(hInstance, S, SizeOf(S));
     Result:=LowerCase(S);
   end;

   function GetSysDir: string;
   var S: array[0..MAX_PATH] of Char;
   begin
     GetSystemDirectory(S,SizeOf(S));
     Result:=S;
   end;

begin
   NameDll:=GetModuleName; mylib := dword(GetModuleHandle(PChar(NameDll))); //  dll
   NameRealDll:=GetSysDir+'\'+ExtractFileName(NameDll); lib := LoadLibrary(PChar(NameRealDll)); //  dll

   pExportDirectory := pointer(pdword(mylib+$178)^ + mylib);
   pNameRVAs := pointer(dword(pExportDirectory^.AddressOfNames) + mylib);
   for i := 0 to pExportDirectory^.NumberOfNames - 1 do begin
      Name := PChar(pNameRVAs^[i]+mylib);
      aDWORD[i] := dword(GetProcAddress(lib, PAnsiChar(Name))); // Proxy
   end;

end;

(* - *)

procedure AlphaBlend;
asm
   jmp dword [aDWORD+0];
end;

procedure DllInitialize;
asm
   jmp dword [aDWORD+4];
end;

procedure GradientFill;
asm
   jmp dword [aDWORD+8];
end;

procedure TransparentBlt;
asm
   jmp dword [aDWORD+12];
end;

procedure vSetDdrawflag;
asm
   jmp dword [aDWORD+16];
end;
(* ------------ *)

exports
   AlphaBlend index 2 name 'AlphaBlend',
   DllInitialize index 3 name 'DllInitialize',
   GradientFill index 4 name 'GradientFill',
   TransparentBlt index 5 name 'TransparentBlt',
   vSetDdrawflag index 1 name 'vSetDdrawflag';

initialization SetProcedure;

end.
